#!/usr/bin/env python3

import tkinter as tk
import math

def reinitialiser():
    ecran.delete(0, tk.END)
    ecran.insert(0, "0")

def ajouter(valeur):
       if ecran.get() == "0":
           ecran.delete(0, tk.END)
       ecran.insert(tk.END, valeur)

def effacer():
    ecran.delete(0, tk.END)


def calculer():
    try:
        expression = ecran.get()
        resultat = round(eval(expression), 4)
        effacer()
        ecran.insert(tk.END, resultat)
    except:
        effacer()
        ecran.insert(tk.END, "E : Division par 0")


def carre():
    try:
        x = float(ecran.get())
        effacer()
        ecran.insert(tk.END, round(x**2,4))
    except:
        effacer()
        ecran.insert(tk.END, "Erreur")

def racine():
    try:
        x = float(ecran.get())
        effacer()
        ecran.insert(tk.END, round(math.sqrt(x),4))
    except:
        effacer()
        ecran.insert(tk.END, "E: <0")

def ln():
    try:
        x = float(ecran.get())
        effacer()
        ecran.insert(tk.END, round(math.log(x),4))
    except:
        effacer()
        ecran.insert(tk.END, "E: <=0")

def log10():
    try:
        x = float(ecran.get())
        effacer()
        ecran.insert(tk.END, round(math.log10(x),4))
    except:
        effacer()
        ecran.insert(tk.END, "E: <=0")

def sinus():
    try:
        x = float(ecran.get())
        x = math.radians(x)
        effacer()
        ecran.insert(tk.END, round(math.sin(x),4))
    except:
        effacer()
        ecran.insert(tk.END, "Erreur")

def cosinus():
    try:
        x = float(ecran.get())
        x = math.radians(x)
        effacer()
        ecran.insert(tk.END, round(math.cos(x),4))
    except:
        effacer()
        ecran.insert(tk.END, "Erreur")

def inserer_pi():
#    effacer()
    ecran.insert(tk.END, round(math.pi,4))


# ----- Fenetre -----
fenetre = tk.Tk()
fenetre.title("Calcul 26.1     ")

try:
    icone = tk.PhotoImage(file="~/calculatrice/Calculatrice.png")
    fenetre.iconphoto(True, icone)
except:
    pass

fenetre.configure(bg="#111111")
fenetre.resizable(False, False)

police = ("Arial", 14)


# ----- Ecran resultat -----
ecran = tk.Entry(
    fenetre,
    width=16,
    font=("Arial", 16),
    justify="right",
    bg="#DFFFE1",
    fg="black",
    bd=4,
    relief="sunken"
)
ecran.grid(row=0, column=0, columnspan=4, padx=10, pady=10)

# initialise à 0
ecran.insert(0,"0")

# ----- Ligne d'information -----
label_info = tk.Label(
    fenetre,
    text="© dada software",
    bg="#111111",
    fg="#CCCCCC",
    font=("Arial", 10)
)
label_info.grid(row=1, column=0, columnspan=4, pady=2)
# ----- Ligne d'information 2----
label_info2 = tk.Label(
    fenetre,
    text="Mode angles en degrés",
    bg="#111111",
    fg="#CCCCCC",
    font=("Arial", 10)
)
label_info2.grid(row=2, column=0, columnspan=4, pady=2)

# ----- Boutons -----
def bouton(parent, texte, commande, couleur="#333333"):
    return tk.Button(
        parent,
        text=texte,
        command=commande,
        font=police,
        width=3,
        height=1,
        bg=couleur,
        fg="white",
        bd=4,
        relief="raised",
        activebackground="#555555",
        activeforeground="white"
    )


# Ligne 1 (scientifiques bleu)		padx=4, pady=4)
bouton(fenetre, "Ln", ln,"#4682B4").grid(row=3, column=0, padx=2, pady=2)
bouton(fenetre, "X²", carre,"#4682B4").grid(row=3, column=1, padx=2, pady=2)
bouton(fenetre, "Sin", sinus,"#4682B4").grid(row=3, column=2, padx=2, pady=2)
bouton(fenetre, "C", reinitialiser, "#AA2222").grid(row=3, column=3,  padx=2, pady=2)

# Ligne 2
bouton(fenetre, "loG", log10,"#4682B4").grid(row=4, column=0,  padx=2, pady=2)
bouton(fenetre, "√", racine,"#4682B4").grid(row=4, column=1, padx=2, pady=2)
bouton(fenetre, "Cos", cosinus,"#4682B4").grid(row=4, column=2, padx=2, pady=2)
bouton(fenetre, "π", inserer_pi, "#6F6A20").grid(row=4, column=3,  padx=2, pady=2)


# ----- Clavier -----
boutons = [
    "7","8","9","÷",
    "4","5","6","*",
    "1","2","3","-",
    "0",".","=","+"
]

def appuyer(x):
    if x == "=":
        calculer()
    elif x == "÷":
        ajouter("/")
    else:
        ajouter(x)

ligne = 6
col = 0

for b in boutons:

    # operateurs
    if b in ["÷","*","-","+"]:
        couleur = "#8C7A5B"     # marron clair

    # =
    elif b == "=":
        couleur = "#9E7017"     # jaune doré

    # chiffres
    else:
        couleur = "#333333"

    bouton(
        fenetre,
        b,
        lambda x=b: appuyer(x),
        couleur
    ).grid(row=ligne, column=col,  padx=5, pady=2)

    col += 1
    if col > 3:
        col = 0
        ligne += 1


fenetre.mainloop()



